package jamezo97.clonecraft.block;

import jamezo97.clonecraft.CloneCraft;
import jamezo97.clonecraft.network.Handler3LifeInducerUpdates;

import java.util.List;
import java.util.Random;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockAntenna extends Block{

//	Icon topBottom;
	
	public BlockAntenna(int par1) {
		super(par1, Material.iron);
		setTextureName("CloneCraft:antenna");
		setBounds();
		this.setTickRandomly(true);
	}

	int renderID = 0;
	
	public void setRenderID(int nextRenderID) {
		renderID = nextRenderID;
	}
	
	

	@Override
	public int tickRate(World par1World) {
		return 0;
	}

	public int getTopAntenna(int x, int y, int z){
		
		return -1;
	}
	
	public int getBottomAntenna(int x, int y, int z){
		
		return -1;
	}

	@Override
	public void updateTick(World world, int x, int y, int z, Random rand) {
		int blockMeta = world.getBlockMetadata(x, y, z);
		if(blockMeta == 0){
			if((world.isRaining() || world.isThundering()) && !world.isRemote){
				int topSolidBlock = world.getTopSolidOrLiquidBlock(x, z);
				
				if(rand.nextInt(world.isThundering()?16:28) == 0){
					int topBlock = world.getTopSolidOrLiquidBlock(x, z)-1;
					if(topBlock > -1){
						int topConductiveFromHere = y;
						int max = 256;
						while(max-- > 0){
							if(topConductiveFromHere == topBlock){
								break;
							}else if(world.getBlockId(x, topConductiveFromHere+1, z) == blockID){
								topConductiveFromHere++;
							}
						}
						if(topConductiveFromHere == topBlock){
							int minX = x - 15;
							int minZ = z - 15;
							int maxX = x + 15;
							int maxZ = z + 15;
							for(int zC = minZ; zC <  maxZ; zC++){
								for(int xC = minX; xC <  maxX; xC++){
									if(zC != z && xC != x){
										int highest = world.getTopSolidOrLiquidBlock(xC, zC)-1;
										if(highest >= topBlock){
											return;
										}
									}
								}
							}
							EntityLightningBolt bolt = new EntityLightningBolt(world, x, topBlock+1, z);
							world.addWeatherEffect(bolt);
							chargeAntenna(x, topBlock, z, world);
						}
					}
				}
			}
		}else if(blockMeta == 1){
			world.setBlock(x, y, z, blockID, 0, 2);
			if(y - 1 > 0){
				if(world.getBlockId(x, y-1, z) == CloneCraft.antenna.blockID){
					chargeAntenna(x, y-1, z, world);
				}else if(world.getBlockId(x, y-1, z) == CloneCraft.lifeInducer.blockID){
					TileEntity e = world.getBlockTileEntity(x, y-1, z);
					if(e == null || e instanceof TileEntityLifeInducer){
						chargeLifeMachine(x, y-1, z, world, (TileEntityLifeInducer)e);
					}
				}else{
					chargeLifeMachine(x, y-1, z, world, null);
					List entities = world.getEntitiesWithinAABB(Entity.class, getCollisionBoundingBoxFromPool(world, x, y, z).expand(10, 8, 10));
					for(int a = 0; a < entities.size(); a++){
						Entity e = (Entity)entities.get(a);
						if(e != null){
				    		double xMid = x+.5;
				    		double yMid = y-.5;
				    		double zMid = z+.5;
				    		
				    		double xE = e.posX;
				    		double yE = e.posY;
				    		double zE = e.posZ;
				    		
				    		double dX = xE - xMid;
				    		double dY = yE - yMid;
				    		double dZ = zE - zMid;
				    		
				    		double distance = /*Math.sqrt*/(dX * dX + dY * dY + dZ * dZ);
				    		e.attackEntityFrom(DamageSource.generic, 4.0f/(float)distance);
				    		dX /= distance;
				    		dY /= distance;
				    		dZ /= distance;
				    		
				    		e.motionX += dX*2;
				    		e.motionY += dY*2;
				    		e.motionZ += dZ*2;
				    		e.velocityChanged = true;
						}
					}
				}
			}
		}

	}
	
	
	public void chargeAntenna(int x, int y, int z, World world){
		world.setBlock(x, y, z, blockID, 1, 2);
		world.scheduleBlockUpdate(x, y, z, blockID, tickRate(world));
		new Handler3LifeInducerUpdates(x, y, z, 0, 0).sendToAllNear(x, y, z, world.provider.dimensionId, 16);
	}

	public void chargeLifeMachine(int x, int y, int z, World world, TileEntityLifeInducer te){
		if(te != null){
			te.charge();
		}
		new Handler3LifeInducerUpdates(x, y, z, 1, 0).sendToAllNear(x, y, z, world.provider.dimensionId, 16);
	}

	@Override
	public Icon getIcon(int par1, int par2) {
		//If the side is the top of bottom (0 or 1)
		if(par1 < 2){
			return CloneCraft.lifeInducer.getTopIconThing();
		}
		if(par2 == 1){
			return charged;
		}
		return super.getIcon(par1, par2);
	}

    public void onEntityCollidedWithBlock(World par1World, int x, int y, int z, Entity e){
    	int meta = par1World.getBlockMetadata(x, y, z);
    	if(meta == 1){
    		e.attackEntityFrom(DamageSource.generic, 4.0f);
    		double xMid = x+.5;
    		double zMid = z+.5;
    		
    		double xE = e.posX;
    		double zE = e.posZ;
    		
    		double dX = xE - xMid;
    		double dZ = zE - zMid;
    		
    		double distance = Math.sqrt(dX * dX + dZ * dZ);
    		
    		e.motionX += dX*3;
    		e.motionZ += dZ*3;
    		e.motionY += .65;
    		
    		
    		
    	}
    }

	@Override
	public int getLightValue(IBlockAccess world, int x, int y, int z) {
		return super.getLightValue(world, x, y, z);
	}


	Icon charged = null;

	@Override
	public void registerIcons(IconRegister ir) {
		super.registerIcons(ir);
		charged = ir.registerIcon("CloneCraft:chargedAntenna");
	}

	
	


	@Override
	public int getBlockColor() {
		return super.getBlockColor();
	}



	@Override
	public boolean isOpaqueCube() {
		return false;
	}

    public void setBounds(){
    	setBlockBounds(.4f, 0, .4f, .6f, 1f, .6f);
    }

	@Override
	public AxisAlignedBB getSelectedBoundingBoxFromPool(World par1World, int x, int y, int z) {
		setBounds();
		return super.getSelectedBoundingBoxFromPool(par1World, x, y, z);
	}

	



	@Override
	public AxisAlignedBB getCollisionBoundingBoxFromPool(World par1World, int x, int y, int z) {
		setBounds();
		return super.getCollisionBoundingBoxFromPool(par1World, x, y, z);
	}



	@Override
	public boolean renderAsNormalBlock() {
		return false;
	}



	@Override
	public int getRenderType() {
		return renderID;
	}






	public int getID() {
		return blockID;
	}
	
	
	
	
	
	

}
